import random
import string

# Define character sets
CATEGORIES = {
    "uppercase": string.ascii_uppercase,
    "lowercase": string.ascii_lowercase,
    "digits": string.digits,
    "special": "!@#$%^&*()-_=+[]{}|;:,.<>?/`~",
    "vowels": "aeiouAEIOU",
    "consonants": "bcdfghjklmnpqrstvwxyzBCDFGHJKLMNPQRSTVWXYZ",
    "hex": "0123456789ABCDEF",
    "binary": "01",
    "letters": string.ascii_letters,
    "all": string.ascii_letters + string.digits + "!@#$%^&*()-_=+[]{}|;:,.<>?/`~"
}

def generate_random_string(selected_categories, length=12):
    """Generate a random string based on selected categories."""
    if not selected_categories:
        selected_categories = ["all"]  # default to all if none selected
    pool = ''.join([CATEGORIES[cat] for cat in selected_categories if cat in CATEGORIES])
    return ''.join(random.choice(pool) for _ in range(length))
